<?php

/*
  Plugin Name: WP-Flash
  Version: 3.1
  Author: CyberSEO.net
  Author URI: http://www.cyberseo.net/
  Description: Innserts the Adobe Flash animation into WordPress blog posts, pages and RSS feeds, using the following tag style: <strong>[swf:url width height bgcolor wmode]</strong>. Where <strong>url</strong> - URL of the flash object (SWF file) you want to embed; <strong>width</strong> - width of the flash object; <strong>height</strong> - height of the flash object; <strong>bgcolor</strong> - background color (optional); <strong>wmode</strong> - wmode, e.g. transparent (optional).
 */

if (!function_exists("add_filter")) {
    die();
}

function wpFlashParseShortcode($string) {
    @list($url, $width, $height, $bgcolor, $wmode) = explode(" ", $string);
    $obj = '';
    if (isset($bgcolor)) {
        $obj .= ' bgcolor="' . $bgcolor . '"';
    }
    if (isset($wmode)) {
        $obj .= ' wmode="' . $wmode . '"';
    }
    return '<embed type="application/x-shockwave-flash" width="' . $width . '" height="' . $height . '" src="' . $url . '"' . $obj . '></embed>';
}
            
function wpFlashInsertSwf($content) {
    return preg_replace_callback("/\[swf: ?(.*?)]/i", function($matches) {
        return str_replace('  ', ' ', stripslashes(wpFlashParseShortcode($matches[1])));
    }, $content);
}

add_filter('the_content', 'wpFlashInsertSwf');
add_filter('the_excerpt', 'wpFlashInsertSwf');
?>