/**
 * WP Social Counter
 * This only run once to reduce page load time.
 *
 * @author mnmlthms
 * @url mnmlthms
 */
;(function( $ ){

    'use strict';

    $(document).ready(function(){

        var $blocks = $('.wp-my-instagram.wpmi[data-cached="false"]'),
            args = {};

    	if( $blocks.length ){

    		$blocks.each(function(){
                var $el = $(this),
                    id = $el.attr('id');

                args[id] = $el.data('args');
            });

            if( args ){

                $.ajax({
                    url: wpMyInstagramVars.ajaxurl,
                    type: 'GET',
                    async: true,
                    cache: false,
                    // dataType: 'json',
                    data: {
                        action: 'wpmi-init-cache',
                        security: wpMyInstagramVars.nonce,
                        args: args
                    }
                }).done( function( response ){

                    if( response && response.data ){
                        for (var key in response.data ) {
                            var $wmmi = $( '#' + key + '.wp-my-instagram.wpmi' );
                            $('.wpmi-list', $wmmi).html( response.data[key] ),
                            $wmmi.attr('data-cached', 'true' );
                        }
                    }
                    
                });
            }
    	}

    });

// Works with either jQuery
})( window.jQuery );
