<?php
/**
 * Template Name: Categories Grid Page
 * Displaying categories images grid if Categories Images plugin is active
 * @see https://wordpress.org/plugins/categories-images/
 * @package Squarex Lite
 */

get_header(); ?>

	<div id="primary" class="content-area<?php if ( !is_active_sidebar( 'sidebar-2' ) ) { ?> no-sidebar<?php } ?>">
		<main id="main" class="site-main" role="main">
			<?php while ( have_posts() ) : the_post(); ?>

				<?php if ( '' != get_the_content() ) : ?>

					<?php get_template_part( 'content', 'page' ); ?>

				<?php endif; ?>

			<?php endwhile; // end of the loop for page content.
			
		if (function_exists('z_init')) {
			foreach (get_categories() as $cat) :
			if ( z_taxonomy_image_url($cat->term_id) ) { ?>
		<div class="box">
			<div class="innerBox" style="background-image: url(<?php echo z_taxonomy_image_url($cat->term_id); ?>);">
				<a href="<?php echo get_category_link($cat->term_id); ?>" rel="bookmark">
					<div class="titleBox">
						<article id="post-<?php the_ID(); ?>"<?php post_class(); ?>>
							<h3<?php if ( ! z_taxonomy_image_url($cat->term_id) ) { ?> class="no-thumb"<?php } ?>>
								<?php echo $cat->cat_name; ?>
							</h3>
						</article>
					</div>
				</a>
			</div><!-- .innerBox -->
		</div><!-- .box -->
	<?php
			}
			endforeach;
		} else {
		?>
		<p style="text-align:center; margin:40px 0;">
			<?php echo esc_html__( 'You need to activate the plugin called Categories Images.', 'squarex-lite' ); ?>
		</p>
	<?php
		}
		?>
		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>